#include "General.h"
#include "NoC4DefuseOnLeave.h"
#include "cPlayer.h"
#include "HashTemplateClass.h"
#include "HashTemplateIterator.h"
#include "engine_vector.h"
#include "NetworkObjectClass.h"
#include "SoldierGameObj.h"
#include "SimpleGameObj.h"
#include "PhysClass.h"
#include "GameObjManager.h"
#include "weaponmgr.h"
#include "ScriptableGameObj.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

struct ProxyOwner_t
{
	ExtendedC4GameObj *C4;
	cPlayer *cPlayer;
};

/* Vector with as key the ID of the proxy C4 object and the value is the cPlayer* of the original owner */
SimpleDynVecClass<ProxyOwner_t> ProxyOwners;

/* Array of bools to cache if a player has spawned yet or not */
bool SpawnedOnce[128];

NoC4DefuseOnLeave::NoC4DefuseOnLeave()
{
	RegisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
	RegisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
	RegisterEvent(EVENT_PLAYER_JOIN_HOOK,this);
	RegisterEvent(EVENT_PLAYER_LEAVE_HOOK,this);
}

NoC4DefuseOnLeave::~NoC4DefuseOnLeave()
{
	UnregisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
	UnregisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
	UnregisterEvent(EVENT_PLAYER_JOIN_HOOK,this);
	UnregisterEvent(EVENT_PLAYER_LEAVE_HOOK,this);
}

/* Attach the "C4NoDefuse_Script" because we need its ::Killed() event */
void NoC4DefuseOnLeave::OnObjectCreate(void *data,GameObject *obj)
{
	/* if C4 and C4 mode is that of a Proxy C4 */
	if (Is_C4(obj) && (Get_C4_Mode(obj) == 3))
	{
		Attach_Script_Once(obj, "C4NoDefuse_Script", "");
		
		/* Set player data to NULL */
		ExtendedC4GameObj* C4 = (ExtendedC4GameObj*)obj;
		C4->Player = 0;

		/* Add C4GameObj pointer and cPlayer* pointer to our vector */
		cPlayer* cP = Find_Player(Get_Player_ID(Get_C4_Planter(obj)));
								
		struct ProxyOwner_t Data;
		Data.C4 = C4;
		Data.cPlayer = cP;

		ProxyOwners.Add(Data);
	}
	else if (Commands->Is_A_Star(obj))
	{
		int ID = Get_Player_ID(obj);

		if (SpawnedOnce[ID] == false)
		{
			SpawnedOnce[ID] = true;
			Restore_Proxy_C4_After_Join(ID);
		}
		
		for (auto c4_node = GameObjManager::C4GameObjList.Head(); c4_node; c4_node = c4_node->Next())
		{		
			ExtendedC4GameObj* C4 = (ExtendedC4GameObj *)c4_node->Data();
			for (int i = 0; i < ProxyOwners.Count(); i++)
			{
				/* if our C4 is in the C4 list and the cPlayer is equal to the owner cPlayer */
				if ((ProxyOwners[i].C4 == C4) && (ProxyOwners[i].cPlayer == Find_Player(ID)))
				{
					/* Restore owner */
					ReferencerClass &Owner = C4->Owner;
					_asm 
					{
						mov ecx, Owner // this pointer
						push obj // argument 1
						mov eax, 0x007080B0
						call eax // call ReferencerClass::operator=(ScriptableGameObj  const*)
					}
				}
			}
		}
	}
}

/* Empty our C4 ownership vector */
void NoC4DefuseOnLeave::OnLoadLevel()
{
	ProxyOwners.Delete_All();
}

/* Restore ownership of Proxy C4 in our ProxyC4OwnerMap to PlayerID,
then remove the entry for his Proxy C4's. */
void Restore_Proxy_C4_After_Join(int PlayerID)
{
	/* Don't do anything if our ProxyOwners vector is empty */
	if (ProxyOwners.Count() == 0) { return; }

	/* Go over all Proxy C4 in the world */
	for (auto c4_node = GameObjManager::C4GameObjList.Head(); c4_node; c4_node = c4_node->Next())
	{		
		ExtendedC4GameObj* C4 = (ExtendedC4GameObj *)c4_node->Data();

		const AmmoDefinitionClass* ammo = C4->AmmoDef;
		int C4Team = Commands->Get_Player_Type((GameObject*)C4);

		/* Check if AmmoType is that of a Proxy C4 and if the c4 team is the same as the player's */
		if ( ((int)ammo->AmmoType == 3) && (C4Team == Get_Team(PlayerID)) )
		{
			/* Check if C4 is a valid pointer and that it doesn't have an owner */
			if (C4 && (Get_C4_Planter((GameObject*)C4) == NULL))
			{
				cPlayer* cP = NULL;

				for (int i = 0; i < ProxyOwners.Count(); i++)
				{
					if (ProxyOwners[i].C4 == C4)
					{
						/* Assign cPlayer*, so entry exists */
						cP = ProxyOwners[i].cPlayer;
						/* Remove entry in the ProxyOwners vector */
						ProxyOwners.Delete(i);
						break;
					}
				}

				/* if an entry exists, i.e. cp != NULL */
				if (cP)
				{
					/* Restore the owner of the Proxy C4 */
					GameObject *PlayerObj = Get_GameObj(PlayerID);
					ReferencerClass &Owner = C4->Owner;
					_asm 
					{
						mov ecx, Owner // this pointer
						push PlayerObj // argument 1
						mov eax, 0x007080B0
						call eax // call ReferencerClass::operator=(ScriptableGameObj  const*)
					}
					/* Set PlayerDataClass to NULL */
					C4->Player = 0;
				}
			}
		}
	}
}
void NoC4DefuseOnLeave::OnPlayerJoin(int PlayerID,const char *PlayerName)
{
	SpawnedOnce[PlayerID] = false;
}

/* Loop over all C4GameObjs and add the ones to our vector that have the same owner
as the player that left. Then set their owner and player data to NULL */
void NoC4DefuseOnLeave::OnPlayerLeave(int PlayerID)
{
	SpawnedOnce[PlayerID] = false;
	/* Go over all Proxy C4 in the world */
	for (auto c4_node = GameObjManager::C4GameObjList.Head(); c4_node; c4_node = c4_node->Next())
	{		
		GameObject *PlayerObj = Get_GameObj(PlayerID);
		ExtendedC4GameObj* C4 = (ExtendedC4GameObj *)c4_node->Data();

		const AmmoDefinitionClass* ammo = C4->AmmoDef;
		int C4Team = Commands->Get_Player_Type((GameObject*)C4);

		/* Check if AmmoType is that of a Proxy C4 and if the c4 team is the same as the player's */
		if ( ((int)ammo->AmmoType == 3) && (C4Team == Get_Team(PlayerID)) )
		{
			/* Check if C4 is a valid pointer and the C4's owner is the same as the player */
			if (C4 && (Get_C4_Planter((GameObject*) C4) == PlayerObj))
			{
				/* Set owner to NULL */
				ReferencerClass &Owner = C4->Owner;
				_asm 
				{
					mov ecx, Owner
					push 0
					mov eax, 0x007080B0
					call eax // call ReferencerClass::operator=(ScriptableGameObj  const*)
				}
				/* Set PlayerDataClass to NULL */
				C4->Player = 0;
			}
		}
	}
}

/* Call the ::Destroyed() event */
void C4NoDefuse_Script::Killed(GameObject *obj, GameObject *shooter)
{
	this->Destroyed(obj);
}

/* Remove an entry from our ProxyC4Owners vector if it exists */
void C4NoDefuse_Script::Destroyed(GameObject *obj)
{
	ExtendedC4GameObj* C4 = (ExtendedC4GameObj*) obj;
	for (int i = 0; i < ProxyOwners.Count(); i++)
	{
		if (ProxyOwners[i].C4 == C4)
		{
			/* Remove entry in the ProxyOwners then break because we're done */
			ProxyOwners.Delete(i);
			break;
		}
	}
}

ScriptRegistrant<C4NoDefuse_Script> C4NoDefuse_Script_Registrant("C4NoDefuse_Script","");

NoC4DefuseOnLeave noC4DefuseOnLeave;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &noC4DefuseOnLeave;
}
